<x-app-layout>
    <x-slot name="header">
        Country
    </x-slot>

    <div class="row row-sm">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <a href="{{ route('admin.location.country.create') }}" class="btn btn-primary">Add New</a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="datatable" class="table table-bordered text-nowrap border-bottom">
                            <thead>
                                <tr>
                                    <th class="border-bottom-0">Name</th>
                                    <th class="border-bottom-0">Code</th>
                                    <th class="border-bottom-0">States</th>
                                    <th class="border-bottom-0">Cities</th>
                                    <th class="border-bottom-0">Status</th>
                                    <th class="border-bottom-0">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($countries as $country)
                                <tr>
                                    <td>
                                        <div class="d-flex">
                                            <div class="avatar-md me-3">
                                                <img src="{{ asset($country->flag) }}"
                                                    class="rounded-4" alt="image">
                                            </div>
                                            <p>
                                                {{ $country->name }}
                                            </p>
                                        </div>
                                    </td>
                                    <td>{{ $country->code }}</td>
                                    <td>{{ $country->states_count }}</td>
                                    <td>{{ $country->cities_count }}</td>
                                    <td>
                                        @if ($country->status == 1)
                                        <span class="badge bg-success">Active</span>
                                        @else
                                        <span class="badge bg-danger">Inactive</span>
                                        @endif
                                    </td>
                                    <td>
                                        <a href="{{ route('admin.location.state.index', $country->id) }}"
                                            class="btn btn-success btn-sm">States</a>
                                        <a href="{{ route('admin.location.country.edit', $country->id) }}"
                                            class="btn btn-primary btn-sm">Edit</a>
                                        <a href="javascript:void(0)" data-url="{{ route('admin.location.country.destroy', $country->id) }}" class="btn btn-danger confirm-me btn-sm">Delete</a>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <x-slot name="script">
        <x-datatable-js />
        <x-confirm-js />
    </x-slot>
</x-app-layout>
